MODULE FComms_tools

!*******************************************************************
!	
!	MODULE contains tools for communicating with C++
!
!*******************************************************************

IMPLICIT none


CONTAINS

	
SUBROUTINE Tests()

!*******************************************************************
!	
!	MODULE contains tools for communicating with C++
!
!*******************************************************************

use, intrinsic :: ISO_C_BINDING

IMPLICIT none

! local variables
character(10) :: txt
integer(c_int) :: txt_len
integer(4) :: ii, jj, mm, nn, aa, bb, flag_f, int_vec(4)
real(8) :: zz, zz1, zz2
real(8), allocatable :: xx(:,:)


!*************************************************************
!	begin code
!*************************************************************

! C++ interfaces
INTERFACE

	SUBROUTINE FCppCom(zz_c) bind(C, name="FCppCom")

		use, intrinsic :: ISO_C_BINDING
		real(c_double) :: zz_c
	END SUBROUTINE FCppCom

	SUBROUTINE FCppCom2(zz1_c, zz2_c) bind(C, name="FCppCom2")

		use, intrinsic :: ISO_C_BINDING
		real(c_double) :: zz1_c, zz2_c
	END SUBROUTINE FCppCom2

	SUBROUTINE FCppCom3(txt_c, txt_lenc, zz2_c) bind(C, name="FCppCom3")

		use, intrinsic :: ISO_C_BINDING
		integer(c_int) :: txt_lenc
		character(c_char) :: txt_c(txt_lenc)
		real(c_double) :: zz2_c
	END SUBROUTINE FCppCom3

	SUBROUTINE FCppCom4(txt_c, txt_lenc, zz2_c) bind(C, name="FCppCom4")

		use, intrinsic :: ISO_C_BINDING
		integer(c_int) :: txt_lenc
		character(c_char) :: txt_c(txt_lenc)
		real(c_double) :: zz2_c
	END SUBROUTINE FCppCom4

	SUBROUTINE FCppCom5(txt_c, txt_lenc, zz2_c, zz3_c) bind(C, name="FCppCom5")

		use, intrinsic :: ISO_C_BINDING
		integer(c_int) :: txt_lenc
		character(c_char) :: txt_c(txt_lenc)
		real(c_double) :: zz2_c, zz3_c
	END SUBROUTINE FCppCom5

	SUBROUTINE FCppCom6(txt_c, txt_lenc, int_vec_c, xx_c) bind(C, name="FCppCom6")

		use, intrinsic :: ISO_C_BINDING
		integer(c_int) :: txt_lenc
		character(c_char) :: txt_c(txt_lenc)
		integer(c_long) :: int_vec_c(4)
		real(c_double) :: xx_c(int_vec(1)*int_vec(2))
	END SUBROUTINE FCppCom6

END INTERFACE

! preliminary variables
ii = 5
jj = 6
mm = 3
nn = 2
allocate( xx(ii, jj) )
do aa = 1, ii
	
	do bb = 1, jj
		
		xx(aa,bb) = aa + ii*(bb-1)
	end do
end do
txt = "Hello" // char(0)
txt_len = Len(trim(txt), kind=c_int)
continue
zz1 = 0.5
zz2 = 1.5
int_vec(1) = ii
int_vec(2) = jj
int_vec(3) = mm
int_vec(4) = nn

! call C++ wrapper
call FCppCom(zz)								! makes simple call to C# and returns a (real8) number from C# (zz)
call FCppCom2(zz1, zz2)							! two real8 numbers transferred to Cpp, Cpp introduces a text variable, and transfers the text variable to C#. C# returns a real number to Fortran (zz2)
call FCppCom3(trim(txt), txt_len, zz2)			! one character variable, and one real8 variable transferred to Cpp.  Cpp creates a new character variable that is copied through to C#, which returns a real number to Fortran (zz2)
call FCppCom4(trim(txt), txt_len, zz2)			! one character variable, and one real8 variable transferred to Cpp.  The Fortran character variable is copied through to C#, which returns a real number to Fortran (zz2)
call FCppCom5(trim(txt), txt_len, zz1, zz2)		! one character variable, and two real8 variables transferred to Cpp.  The Fortran character variable and one real8 variable (zz1) are copied through to C#, which returns a real number generated from zz1 to Fortran (zz2)
call FCppCom6(trim(txt), txt_len, int_vec, xx)	! one character variable, one int4 vector, and one real8 2d matrix transferred to C#.  C# edits the elements of the real matrix and returns to Fortran.
continue

! clean-up
deallocate (xx)


END SUBROUTINE Tests


END MODULE FComms_tools